/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.legacy;

import com.floragunn.searchguard.enterprise.dlsfls.legacy.DlsFlsProcessedConfig;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.support.SgUtils;
import com.floragunn.searchguard.support.WildcardMatcher;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;

public class FlsFieldFilter
implements Function<String, Predicate<String>> {
    private static final String KEYWORD = ".keyword";
    private final ThreadPool threadPool;
    private final AtomicReference<DlsFlsProcessedConfig> config;

    FlsFieldFilter(ThreadPool threadPool, AtomicReference<DlsFlsProcessedConfig> config) {
        this.threadPool = threadPool;
        this.config = config;
    }

    @Override
    public Predicate<String> apply(String index) {
        if (this.threadPool == null) {
            return field -> true;
        }
        if (!this.config.get().isEnabled()) {
            return field -> true;
        }
        Map allowedFlsFields = (Map)((Object)HeaderHelper.deserializeSafeFromHeader((ThreadContext)this.threadPool.getThreadContext(), (String)"_sg_fls_fields"));
        String eval = SgUtils.evalMap((Map)allowedFlsFields, (String)index);
        if (eval == null) {
            return field -> true;
        }
        Set includesExcludes = (Set)allowedFlsFields.get(eval);
        HashSet<String> includesSet = new HashSet<String>(includesExcludes.size());
        HashSet<String> excludesSet = new HashSet<String>(includesExcludes.size());
        for (String incExc : includesExcludes) {
            char firstChar = incExc.charAt(0);
            if (firstChar == '!' || firstChar == '~') {
                excludesSet.add(incExc.substring(1));
                continue;
            }
            includesSet.add(incExc);
        }
        if (!excludesSet.isEmpty()) {
            return field -> !WildcardMatcher.matchAny((Collection)excludesSet, (String)FlsFieldFilter.handleKeyword(field));
        }
        return field -> WildcardMatcher.matchAny((Collection)includesSet, (String)FlsFieldFilter.handleKeyword(field));
    }

    private static String handleKeyword(String field) {
        if (field != null && field.endsWith(KEYWORD)) {
            return field.substring(0, field.length() - KEYWORD.length());
        }
        return field;
    }
}

